local t = Def.ActorFrame{}
local function GetElementPosX(self,element) return element:GetX() end
local function GetElementPosY(self,element)	return element:GetY() end
local Player = MetroQuad.Global.ModPanel.Player

local AbleToMoveLeft = 0
local AbleToMoveRight = 3
local AbleToMoveUp = 0
local AbleToMoveDown = 6

local Text = LoadFile("ThemeColor.cfg","Settings") -- Set the Initial Text value.
local Key = ""
local ElementX = (Player == PLAYER_1 and CenterX()-320) or CenterX()+320
local Element2X = (Player == PLAYER_1 and CenterX()-196) or CenterX()+196
local ButtonX = (Player == PLAYER_1 and 49) or 689
local ButtonY = 200

t[#t+1] = LoadActor(THEME:GetPathS("","Common Start"))..{
	CodeMessageCommand=function(self,param)
		if param.PlayerNumber == Player then
			if param.Name == "Start" then
				self:play()
			end
		end
	end;
};

local hValue = 0
local sValue = 1
local vValue = 1

local bHue = 0
local bSat = 1
local bVal = 1

local CursorPos
local xPos, yPos
local InputText

local function InputCallback(event)
	local pn = event.PlayerNumber
	if event.type == "InputEventType_Release" then return false end
	if pn == Player then
		if event.GameButton == "MenuLeft" then
			if AbleToMoveLeft > 0 then
				CursorPos:addx(-39)
				AbleToMoveLeft = AbleToMoveLeft - 1
				AbleToMoveRight = AbleToMoveRight + 1
			end
		end
		if event.GameButton == "MenuRight" then
			if AbleToMoveRight > 0 then
				CursorPos:addx(39)
				AbleToMoveLeft = AbleToMoveLeft + 1
				AbleToMoveRight = AbleToMoveRight - 1
			end
		end
		if event.GameButton == "MenuUp" then
			if AbleToMoveUp > 0 then
				CursorPos:addy(-24-4)
				AbleToMoveUp = AbleToMoveUp - 1
				AbleToMoveDown = AbleToMoveDown + 1
			end
		end
		if event.GameButton == "MenuDown" then
			if AbleToMoveDown > 0 then
				CursorPos:addy(24+4)
				AbleToMoveUp = AbleToMoveUp + 1
				AbleToMoveDown = AbleToMoveDown - 1
			end
		end
		if event.GameButton == "Start" then
			if Text == "" then Text = "#" end
			if xPos:GetX() == ButtonX and yPos:GetY() == ButtonY then
				Key = 1 Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText()
				end
			end
			if xPos:GetX() == ButtonX+39 and yPos:GetY() == ButtonY then
				Key = 2 Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText()
				end
			end
			if xPos:GetX() == ButtonX+39*2 and yPos:GetY() == ButtonY then
				Key = 3 Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText()
				end
			end
			if xPos:GetX() == ButtonX+39*3 and yPos:GetY() == ButtonY then
				Key = 4 Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText()
				end
			end
			if xPos:GetX() == ButtonX and yPos:GetY() == ButtonY+28 then
				Key = 5 Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText()
				end
			end
			if xPos:GetX() == ButtonX+39 and yPos:GetY() == ButtonY+28 then
				Key = 6 Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText()
				end
			end
			if xPos:GetX() == ButtonX+39*2 and yPos:GetY() == ButtonY+28 then
				Key = 7 Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText() 
				end
			end
			if xPos:GetX() == ButtonX+39*3 and yPos:GetY() == ButtonY+28 then
				Key = 8 Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText()
				end
			end
			if xPos:GetX() == ButtonX and yPos:GetY() == ButtonY+28*2 then
				Key = 9 Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText()
				end
			end
			if xPos:GetX() == ButtonX+39 and yPos:GetY() == ButtonY+28*2 then 
				Key = 0 Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText()
				end
			end
			if xPos:GetX() == ButtonX+39*2 and yPos:GetY() == ButtonY+28*2 then
				Key = "A" Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText()
				end
			end
			if xPos:GetX() == ButtonX+39*3 and yPos:GetY() == ButtonY+28*2 then
				Key = "B" Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText()
				end
			end
			if xPos:GetX() == ButtonX and yPos:GetY() == ButtonY+28*3 then
				Key = "C" Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText()
				end
			end
			if xPos:GetX() == ButtonX+39 and yPos:GetY() == ButtonY+28*3 then 
				Key = "D" Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText()
				end
			end
			if xPos:GetX() == ButtonX+39*2 and yPos:GetY() == ButtonY+28*3 then
				Key = "E" Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText()
				end
			end
			if xPos:GetX() == ButtonX+39*3 and yPos:GetY() == ButtonY+28*3 then
				Key = "F" Text = Text .. Key InputText:settext(Text)
				if string.len(Text) > 7 then
					InputText:settext("#FFFFFF")
					Text = InputText:GetText()
				end
			end
			if xPos:GetX() == ButtonX and yPos:GetY() == ButtonY+28*4 then 
				if InputText:GetText() == "" then
					SCREENMAN:SystemMessage("ERROR: No Hex Color Code entered.")
				elseif string.len(InputText:GetText()) < 7 then
					SCREENMAN:SystemMessage("ERROR: Incompleted Hex Color Code. (Format: #123456).")
				else
					WriteFile("ThemeColor.cfg",Text,"Settings")
					MESSAGEMAN:Broadcast("ThemeColorChanged")
					SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen")
				end
			end
			if xPos:GetX() == ButtonX+39 and yPos:GetY() == ButtonY+28*4 then
				Text = "" InputText:settext(Text)
			end
			if xPos:GetX() == ButtonX+39*2 and yPos:GetY() == ButtonY+28*4 then
				Text = Text:sub(1, -2)
				InputText:settext(Text)
			end
			if xPos:GetX() == ButtonX+39*3 and yPos:GetY() == ButtonY+28*4 then
				SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen")
			end
			if xPos:GetX() == ButtonX and yPos:GetY() == ButtonY+28*5 then
				hValue = hValue + 4 bHue = bHue + 2
				if hValue > 360 then hValue = 360 end
				if bHue > 180 then bHue = 180 end
			end
			if xPos:GetX() == ButtonX+39 and yPos:GetY() == ButtonY+28*5 then
				sValue = sValue + 0.01 bSat = bSat - 1.775
				if sValue > 1 then sValue = 1 end
				if bSat < 1 then bSat = 1 end
			end
			if xPos:GetX() == ButtonX+39*2 and yPos:GetY() == ButtonY+28*5 then
				vValue = vValue + 0.01 bVal = bVal - 1.775
				if vValue > 1 then vValue = 1 end
				if bVal < 1 then bVal = 1 end
			end
			if xPos:GetX() == ButtonX and yPos:GetY() == ButtonY+28*6 then
				hValue = hValue - 4 bHue = bHue - 2
				if hValue < 0 then hValue = 0 end
				if bHue < 0 then bHue = 0 end
			end
			if xPos:GetX() == ButtonX+39 and yPos:GetY() == ButtonY+28*6 then
				sValue = sValue - 0.01 bSat = bSat + 1.775
				if sValue < 0 then sValue = 0 end
				if bSat > 179 then bSat = 179 end
			end
			if xPos:GetX() == ButtonX+39*2 and yPos:GetY() == ButtonY+28*6 then
				vValue = vValue - 0.01 bVal = bVal + 1.775
				if vValue < 0 then vValue = 0 end
				if bVal > 179 then bVal = 179 end
			end
		end
	end
end

local HueIndicator, SatIndicator, ValIndicator
local SatBar, ValBar, ColorText, QuadColor

local function UpdateTextsCallback(event)
	local CurrentColor = {
		Hue = hValue,
		Sat = sValue,
		Value = vValue,
		Alpha = 1
	};
	local color = HSVToColor(CurrentColor);
	local colorX = ColorToHex(color);
		
	local pn = event.PlayerNumber
	if event.type == "InputEventType_Release" then return false end
	if pn == Player then
		if event.GameButton == "Start" then
			HueIndicator:y(Top()+176+20+5+bHue);
			SatIndicator:y(Top()+176+20+4+bSat);
			ValIndicator:y(Top()+176+20+4+bVal);
			SatBar:diffuse(HSV(hValue,sValue,vValue));
			SatBar:diffusetopedge(HSV(hValue,sValue,vValue));
			SatBar:diffusebottomedge(HSV(0,0,vValue));
			ValBar:diffuse(HSV(hValue,1,1));
			ValBar:diffusebottomedge(HSV(hValue,1,0));
			
			ColorText:diffuse(HSV(hValue,sValue,vValue));
			ColorText:settext(string.sub("#"..colorX,1,7))
			QuadColor:diffuse(HSV(hValue,sValue,vValue));
		end
	end
end

t[#t+1] = Def.ActorFrame{
	InitCommand=function(self) self:draworder(-1) end;
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX;y,CenterY()+32;zoomto,172,254;diffuse,color(LoadFile("ThemeColor.cfg","Settings")));};
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX;y,CenterY()+32;zoomto,164,254-12;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2.5));};
	Def.Quad{InitCommand=cmd(draworder,-1;x,ElementX;y,Top()+172;zoomto,100,20;valign,0;diffuse,Black();diffusealpha,0.5);};
}

t[#t+1] = Def.ActorFrame{
	InitCommand=function(self) self:draworder(5) local c = self:GetChildren(); c.InputText:settext(Text) end;
	OnCommand=function(self)
		local c = self:GetChildren();
		local CurrentColor = {
			Hue = hValue,
			Sat = sValue,
			Value = vValue,
			Alpha = 1
		};
		local color = HSVToColor(CurrentColor);
		local colorX = ColorToHex(color);
		
		c.HueIndicator:y(Top()+176+20+5+bHue);
		c.SatIndicator:y(Top()+176+20+4+bSat);
		c.ValIndicator:y(Top()+176+20+4+bVal);
		c.SatBar:diffuse(HSV(hValue,sValue,vValue));
		c.SatBar:diffusetopedge(HSV(hValue,sValue,vValue));
		c.SatBar:diffusebottomedge(HSV(0,0,vValue));
		c.ValBar:diffuse(HSV(hValue,1,1));
		c.ValBar:diffusebottomedge(HSV(hValue,1,0));
		
		c.ColorText:diffuse(HSV(hValue,sValue,vValue));
		c.ColorText:settext(string.sub("#"..colorX,1,7))
		c.QuadColor:diffuse(HSV(hValue,sValue,vValue));
	end;
	
	CommonNormal()..{Text="ENTERS HEX COLOR"; InitCommand=cmd(xy,ElementX,Top()+154;valign,0;zoom,0.5;);};
	CommonNormal()..{Text="SAMPLE COLOR"; InitCommand=cmd(xy,Element2X,Top()+150;valign,0;zoom,0.4;maxwidth,156);};
	CommonNormal()..{Name="ColorText"; InitCommand=cmd(xy,Element2X,Top()+164;valign,0;zoom,0.4;maxwidth,196;shadowcolor,White();shadowlength,0.5);
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(UpdateTextsCallback) ColorText=self end;
	};
	Def.Quad{Name="QuadColor"; InitCommand=cmd(xy,Element2X,Top()+176;setsize,60,20;valign,0);
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(UpdateTextsCallback) QuadColor=self end;
	};
	LoadActor("_HueBar")..{InitCommand=cmd(xy,Element2X-20,Top()+176+20+12;valign,0;zoom,0.7);};
	LoadActor("_ArrowIndicator")..{Name="HueIndicator"; InitCommand=cmd(x,Element2X-29;valign,0;zoom,0.4);
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(UpdateTextsCallback) HueIndicator=self end;
	};
	LoadActor("_SatBar")..{Name="SatBar"; InitCommand=cmd(xy,Element2X,Top()+176+20+12;valign,0;zoom,0.7); 
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(UpdateTextsCallback) SatBar=self end;
	};
	LoadActor("_ArrowIndicator")..{Name="SatIndicator"; InitCommand=cmd(x,Element2X-9;valign,0;zoom,0.4);
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(UpdateTextsCallback) SatIndicator=self end;
	};
	LoadActor("_SatBar")..{Name="ValBar"; InitCommand=cmd(xy,Element2X+20,Top()+176+20+12;valign,0;zoom,0.7);
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(UpdateTextsCallback) ValBar=self end;
	};
	LoadActor("_ArrowIndicator")..{Name="ValIndicator"; InitCommand=cmd(x,Element2X+11;valign,0;zoom,0.4);
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(UpdateTextsCallback) ValIndicator=self end;
	};
	CommonNormal()..{Name="InputText"; InitCommand=cmd(draworder,1;xy,ElementX,Top()+172+4;zoom,0.6;valign,0;diffuse,PlayerColor(Player));
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(InputCallback) InputText=self end;
	};
	Def.Quad{Name="SampleQuad"; InitCommand=cmd(draworder,-1;x,Element2X;y,CenterY()+32;zoomto,68,254;diffuse,ColorMidTone(color(LoadFile("ThemeColor.cfg","Settings"))));};
	Def.Quad{Name="Cursor"; InitCommand=cmd(x,ElementX-58;y,Top()+200;zoomto,32,20;valign,0;diffuse,PlayerColor(Player));
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(InputCallback) CursorPos=self xPos=self yPos=self end;
	};
}

for i = 1,4 do -- Text Numbers (1 to 4)
	t[#t+1] = Def.ActorFrame{InitCommand=cmd(draworder,10); CommonNormal()..{Text=i; InitCommand=cmd(xy,ElementX-97+39*i,Top()+200+4;zoom,0.5;valign,0);};}
end
for i = 1,4 do -- Text Numbers (5 to 8)
	t[#t+1] = Def.ActorFrame{InitCommand=cmd(draworder,10); CommonNormal()..{Text=i+4; InitCommand=cmd(xy,ElementX-97+39*i,Top()+200+24+4*2;zoom,0.5;valign,0);};}
end

t[#t+1] = Def.ActorFrame{
	InitCommand=cmd(draworder,10);
	-- Text Numbers (9 to B)
	CommonNormal()..{Text="9"; InitCommand=cmd(xy,ElementX-58,Top()+200+24*2+4*3;zoom,0.5;valign,0);};
	CommonNormal()..{Text="0"; InitCommand=cmd(xy,ElementX-58+39,Top()+200+24*2+4*3;zoom,0.5;valign,0);};
	CommonNormal()..{Text="A"; InitCommand=cmd(xy,ElementX-58+39*2,Top()+200+24*2+4*3;zoom,0.5;valign,0);};
	CommonNormal()..{Text="B"; InitCommand=cmd(xy,ElementX-58+39*3,Top()+200+24*2+4*3;zoom,0.5;valign,0);};
	-- Text Numbers (C to F)
	CommonNormal()..{Text="C"; InitCommand=cmd(xy,ElementX-58,Top()+200+24*3+4*4;zoom,0.5;valign,0);};
	CommonNormal()..{Text="D"; InitCommand=cmd(xy,ElementX-58+39,Top()+200+24*3+4*4;zoom,0.5;valign,0);};
	CommonNormal()..{Text="E"; InitCommand=cmd(xy,ElementX-58+39*2,Top()+200+24*3+4*4;zoom,0.5;valign,0);};
	CommonNormal()..{Text="F"; InitCommand=cmd(xy,ElementX-58+39*3,Top()+200+24*3+4*4;zoom,0.5;valign,0);};
	-- Action Texts
	CommonNormal()..{Text="OK"; InitCommand=cmd(xy,ElementX-58,Top()+200+24*4+4*5;zoom,0.5;valign,0);};
	CommonNormal()..{Text="DEL"; InitCommand=cmd(xy,ElementX-58+39,Top()+200+24*4+4*5;zoom,0.5;valign,0);};
	CommonNormal()..{Text="CLR"; InitCommand=cmd(xy,ElementX-58+39*2,Top()+200+24*4+4*5;zoom,0.5;valign,0);};
	CommonNormal()..{Text="BACK"; InitCommand=cmd(xy,ElementX-58+39*3,Top()+200+24*4+4*5;zoomx,0.3;zoomy,0.5;valign,0);};
	-- HSV+ Texts
	CommonNormal()..{Text="H+"; InitCommand=cmd(xy,ElementX-58,Top()+200+24*5+4*6;zoom,0.5;valign,0);};
	CommonNormal()..{Text="S+"; InitCommand=cmd(xy,ElementX-58+39,Top()+200+24*5+4*6;zoom,0.5;valign,0);};
	CommonNormal()..{Text="V+"; InitCommand=cmd(xy,ElementX-58+39*2,Top()+200+24*5+4*6;zoom,0.5;valign,0);};
	CommonNormal()..{Text="-"; InitCommand=cmd(xy,ElementX-58+39*3,Top()+200+24*5+4*6;zoomx,0.3;zoomy,0.5;valign,0);};
	-- HSV- Texts
	CommonNormal()..{Text="H-"; InitCommand=cmd(xy,ElementX-58,Top()+200+24*6+4*7;zoom,0.5;valign,0);};
	CommonNormal()..{Text="S-"; InitCommand=cmd(xy,ElementX-58+39,Top()+200+24*6+4*7;zoom,0.5;valign,0);};
	CommonNormal()..{Text="V-"; InitCommand=cmd(xy,ElementX-58+39*2,Top()+200+24*6+4*7;zoom,0.5;valign,0);};
	CommonNormal()..{Text="-"; InitCommand=cmd(xy,ElementX-58+39*3,Top()+200+24*6+4*7;zoomx,0.3;zoomy,0.5;valign,0);};
}

for i = 1,4 do -- Row 1 Quads
	t[#t+1] = Def.ActorFrame{InitCommand=cmd(draworder,2); Def.Quad{InitCommand=cmd(;x,ElementX-97+39*i;y,Top()+200;zoomto,32,20;valign,0;diffuse,Black();diffusealpha,0.5);};}
end
for i = 1,4 do -- Row 2 Quads
	t[#t+1] = Def.ActorFrame{InitCommand=cmd(draworder,2); Def.Quad{InitCommand=cmd(;x,ElementX-97+39*i;y,Top()+200+28;zoomto,32,20;valign,0;diffuse,Black();diffusealpha,0.5);};}
end
for i = 1,4 do -- Row 3 Quads
	t[#t+1] = Def.ActorFrame{InitCommand=cmd(draworder,2); Def.Quad{InitCommand=cmd(;x,ElementX-97+39*i;y,Top()+200+28*2;zoomto,32,20;valign,0;diffuse,Black();diffusealpha,0.5);};}
end
for i = 1,4 do -- Row 4 Quads
	t[#t+1] = Def.ActorFrame{InitCommand=cmd(draworder,2); Def.Quad{InitCommand=cmd(;x,ElementX-97+39*i;y,Top()+200+28*3;zoomto,32,20;valign,0;diffuse,Black();diffusealpha,0.5);};}
end
for i = 1,4 do -- Row 5 Quads
	t[#t+1] = Def.ActorFrame{InitCommand=cmd(draworder,2); Def.Quad{InitCommand=cmd(;x,ElementX-97+39*i;y,Top()+200+28*4;zoomto,32,20;valign,0;diffuse,Green();diffusealpha,0.5);};}
end
for i = 1,4 do -- Row 6 Quads
	t[#t+1] = Def.ActorFrame{InitCommand=cmd(draworder,2); Def.Quad{InitCommand=cmd(;x,ElementX-97+39*i;y,Top()+200+28*5;zoomto,32,20;valign,0;diffuse,Black();diffusealpha,0.5);};}
end
for i = 1,4 do -- Row 7 Quads
	t[#t+1] = Def.ActorFrame{InitCommand=cmd(draworder,2); Def.Quad{InitCommand=cmd(;x,ElementX-97+39*i;y,Top()+200+28*6;zoomto,32,20;valign,0;diffuse,Black();diffusealpha,0.5);};}
end

return t